%% History of a theory
% Martin + Mark 27 Aug 2020
clear, clc, close all

%%
t1 = 1980 : 2020;
x1 = normpdf(t1,2004,4);
x1 = 800 * x1 / sum(x1);
x1 = x1 + 0.4 * t1 - 792;
t2 = 2012 : 2015;
x2 = (37.9-0)/(2010-2015) * t2 - 2015 * (37.9-0)/(2010-2015);

%%
dates_neutr = [
    1984    150
    1989    150
    1996.5  150
    1997.5  150
    ];
refs_neutr = [
    "Shackleton et al. 1984"
    "Raymo et al. 1989"
    "Maslin et al. 1996"
    "Haug and Tiedemann 1998"
    ];

dates_pro = [
    1991    150
    1993.5  150
    1994.5  150
    1995.5  150
    1996.5  150
    2000    150
    2002    150
    2003    150
    2005.4  150
    2006.5  150
    2010.5  150
    2012.5  150
    2015    150
    2015.5  150
    2018.5  150
    2020.4  150
    ];
refs_pro = {
    "deMenocal et al. 1991"
    "Vrba 1994"
    "Vrba 1995"
    "deMenocal and Bloemendal 1995"
    "deMenocal 1995"
    "Vrba 2000"
    "Bobe et al. 2002"
    "Bobe et al. 2004"
    "deMenocal 2004"
    "Fernandez and Vrba 2006"
    "Bonnefille 2010"
    "Bibi et al. 2013"
    "Bibi et al. 2015"
    "DiMaggio et al. 2015"
    "Joordens et al. 2019"
    "Lupien et al. 2019"
    };

dates_con = [
    1997    150
    2001    150
    2003.6  150
    2004.5  150
    2006.25 150
    2007    150
    2008.5  150
    2012.5  150
    2013.5  150
    2016    150
    2016    150
    2016.5  150
    2016.5  150
    2017.5  150
    2019.5  149
    2021.5  150
    ];
refs_con = {
    "Behrensmeyer et al. 1997"
    "Cane and Molnar 2001"
    "Larrasoana et al. 2003"
    "Ravelo et al. 2004"
    "Trauth et al. 2005"
    "Trauth et al. 2007"
    "Trauth et al. 2009"
    "deMenocal 2012"
    "Bibi et al. 2015"
    "Liddy et al. 2016"
    "Rose et al. 2016"
    "Uno et al. 2016"
    "Grant et al. 2017"
    "Blumenthal et al. 2017"
    "Polissar et al. 2019"
    "Trauth et al., this work"
    };

%%
f1 = figure('Position',[300 400 800 600],...
    'Color',[1 1 1]);

axes('Units','Centimeters',...
    'Position',[3 3 18 6],...
    'LineWidth',1,...
    'FontSize',12,...
    'XLim',[1980 2020],...
    'YLim',[0 100])

line(t1,x1,...
    'LineWidth',2,...
    'Color','k')

text(1985,52,'Definition ONHG',...
    'HorizontalAlignment','center',...
    'FontSize',12)
text(1985,44,'Shackleton et al. 1984',...
    'HorizontalAlignment','center',...
    'FontSize',12)

text(1993,30,'Airlie workshop',...
    'HorizontalAlignment','center',...
    'FontSize',12)

text(1995,70,'Publication of',...
    'HorizontalAlignment','center',...
    'FontSize',12)
text(1995,60,'initial hypothesis',...
    'HorizontalAlignment','center',...
    'FontSize',12)

text(1994,105,'Definition INHG',...
    'HorizontalAlignment','center',...
    'FontSize',12)
text(1994,98,'Raymo 1994',...
    'HorizontalAlignment','center',...
    'FontSize',12)

text(2005,45,'Widely used',...
    'HorizontalAlignment','center',...
    'FontSize',12)
text(2005,35,'in textbooks',...
    'HorizontalAlignment','center',...
    'FontSize',12)

text(2021,20,'Persistence of a',...
    'HorizontalAlignment','left',...
    'FontSize',12)
text(2021,10,'falsified hypothesis',...
    'HorizontalAlignment','left',...
    'FontSize',12)

text(1990,135,'Pro papers',...
    'Color',[0.5 0.7 0.2],...
    'HorizontalAlignment','right',...
    'FontSize',12)
text(1996.5,142,'Contra papers',...
    'Color',[0.8 0.3 0.1],...
    'HorizontalAlignment','right',...
    'FontSize',12)

text(dates_neutr(:,1),dates_neutr(:,2),refs_neutr,...
    'Rotation',45,...
    'Color',[0.6 0.6 0.6],...
    'FontSize',12)
text(dates_pro(:,1),dates_pro(:,2),refs_pro,...
    'Rotation',45,...
    'Color',[0.5 0.7 0.2],...
    'FontSize',12)
text(dates_con(:,1),dates_con(:,2),refs_con,...
    'Rotation',45,...
    'Color',[0.8 0.3 0.1],...
    'FontSize',12)

xlabel('Year')
ylabel('Hypothesis Acceptance (%)')

annotation(f1,'arrow',[0.173 0.173],[0.24 0.21]);
annotation(f1,'arrow',[0.32 0.32],[0.21 0.18]);
annotation(f1,'arrow',[0.348 0.348],[0.29 0.26]);
annotation(f1,'arrow',[0.334 0.334],[0.40 0.37]);
annotation(f1,'arrow',[0.5 0.5],[0.21 0.18])

annotation(f1,'arrow',[0.28 0.55],[0.52 0.52],...
    'Color',[0.5 0.7 0.2],...
    'LineWidth',2)
annotation(f1,'arrow',[0.38 0.77],[0.54 0.54],...
    'Color',[0.8 0.3 0.1],...
    'LineWidth',2)
annotation(f1,'arrow',[0.55 0.75],[0.52 0.52],...
    'Color',[0.5 0.7 0.2],...
    'LineWidth',2,...
    'LineStyle',':')


%%
print -dpng -r300 history_of_a_theory_vs2.png
print -depsc2 history_of_a_theory_vs2.eps

    
